% dal-exam.cls
%
% A LaTeX2e document class for preparing exams.
%
% Designed layout for Faculty of Computer Science, Dalhousie
% University.
%
% Prepared by Vlado Keselj, 2004-5.
%
% Requires the package exam.cls by Philip Hirschhorn.
%
% If you want to modify the file, please change its name first (i.e.,
% do not use dal-exam.cls).

\def\fileversion{1.2}
\def\filedate{2005/04/07}

\NeedsTeXFormat{LaTeX2e}

\ProvidesClass{dal-exam}[\filedate\space Version \fileversion\space by
  Vlado Keselj]

\RequirePackage{ifthen}
\RequirePackage{graphicx}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{exam}}
\ProcessOptions
\LoadClass{exam}

% ** ADJUST PAGE LAYOUT **

\setlength{\textheight}{10in}
\setlength{\topmargin}{0cm}

% ** SET HEADERS **

\lhead{\sl\small\courseid, \examdate, \examtitle}
\chead{}
\rhead{\sl\small Page \thepage\ of \numpages}
\lfoot{}
\cfoot{}
\rfoot{}
\firstpageheader{}{}{\sl\small Page \thepage\ of \numpages}

%% *** TITLE PAGE ***

\newcommand{\@mksch}[2]{\raisebox{0pt}[4ex][0pt]%
{\mbox{{\LARGE #1}}} & \hfill\makebox[6mm][l]{\small/#2}}

\newcommand{\FirstPageInstructions}
{Exam Type: & {\bf Closed Book} \\
 &\\
 Additional&\\
 Materials Allowed: & {\bf No} \\
                    %{\bf Calculator} \\
}

\def\@mschemerows{%
  \setcounter{@iterator}{0}%
  \do@mschemerows
}
\def\do@mschemerows{%
  \addtocounter{@iterator}{1}%
  \@mksch{\the@iterator}{\pointsofquestion{\the@iterator}}\\\hline
  \ifnum \the@iterator < \numquestions\relax
    \let\next@mschemerows=\do@mschemerows
  \else
    \let\next@mschemerows=\relax
  \fi
  \next@mschemerows
}

\newcommand\maketitlepage{
\vspace*{-1.4cm}\noindent
\makebox[0pt][l]{\parbox{.5\textwidth}
{\large\sl Faculty of Computer Science\\[0mm]\includegraphics[width=65mm]{dal2col}}}

\vspace{-15mm}
\hfill
\begin{tabular}{r}
\LARGE\bf \examtitle\\[2mm]
\normalsize\rm Term: \courseterm %\hspace{2cm}
\end{tabular}

\vspace{10mm}
\noindent
\begin{tabular}{|l|}
\hline
{\bf Student ID Information}\\
\rule{.65\textwidth}{0pt}\\[2mm]
\raisebox{3mm}{\hbox{\bf Last name:}}  \rule{.33\textwidth}{0.5pt}
\raisebox{3mm}{\hbox{\bf First name:}} \rule{.33\textwidth}{0.5pt}
\\[.5cm]
\raisebox{3mm}{\hbox{\bf Student ID \#:}}    \rule{.27\textwidth}{0.5pt}
\raisebox{3mm}{\hbox{\bf CS.Dal.Ca userid:}} \rule{.27\textwidth}{0.5pt}
\\
\hline
\end{tabular}

\bigskip\noindent
\begin{tabular}[t]{|ll|}
\hline
&\\
Course ID:                   & {\bf \courseid} \\
&\\
Course Title:                & \parbox{7cm}{\coursetitle} \\
&\\
Instructor:                   & \instructor\\
&\\
Date of Exam: & \examdate \\
&\\
Time Period: \hfill Start: & \examstarttime \\
             \hfill   End: & \examendtime \\
&\\
Duration of Exam: & \examduration     \\
&\\
Number of Exam Pages: & \numpages\ pages \\
\multicolumn{2}{|l|}{(including this cover sheet)} \\
&\\
\FirstPageInstructions
&\\
\cline{1-2}
\end{tabular}%
\if@addpoints
 \@ifundefined{exam@numpoints}%
    {\ClassWarning{dal-exam}{You must run LaTeX one more time\MessageBreak
                \space\space to produce the grade table.\MessageBreak}%
    }%
    {\begin{tabular}[t]{|c|r|}
     \hline
     \multicolumn{2}{|c|}{\rule[-1mm]{0pt}{3ex}\hspace*{7mm}Grade Table\hspace*{7mm}} \\
     \hline
     \multicolumn{2}{|c|}{Question \hfill Score} \\ \hline
     \@mschemerows
     \@mksch{$\Sigma$}{\numpoints}\\
     \hline
     \end{tabular}
    }%
  \else
    \ClassWarning{dal-exam}{%
      To produce the grade table you must give the command \protect\addpoints\MessageBreak
      \MessageBreak
      }%
  \fi
\newpage
}

\endinput
